<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class System_part extends Model 
{

    protected $table = 'system_part';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function system_route()
    {
        return $this->hasMany('App\Models\System_route', 'system_part_id');
    }

    public function user_group_part()
    {
        return $this->hasMany('App\Models\Group_system_part', 'system_part_id');
    }

}